<?php
/****
 * vB Optimise
 * Copyright 2010; Deceptor
 * All Rights Reserved
 * Code may not be copied, in whole or part without written permission
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

error_reporting(E_ALL & ~E_NOTICE);

$phrasegroups = array('diagnostic');
$specialtemplates = array();

require_once('./global.php');

// ############################# LOG ACTION ###############################
log_admin_action();


// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

// ###################### vB Optimise: Manual Flush #######################

if ($_REQUEST['do'] == 'flush')
{
	print_cp_header($vbphrase['vboptimise_manualflush']);

	if ($vbulletin->options['vbo_online'])
	{
		vb_optimise::$cache->flush(false);
	}

	print_table_start();
	print_table_header($vbphrase['vboptimise_manualflush']);
	print_description_row($vbphrase['vboptimise_flushed']);
	print_table_footer();
	print_cp_footer();
}

// ###################### vB Optimise: Test Setup #######################

if ($_REQUEST['do'] == 'test')
{
	if (!$vbulletin->options['vbo_online'])
	{
		print_cp_header($vbphrase['vboptimise_testsetup']);
		print_cp_message($vbphrase['vboptimise_testsetup_offline']);
	}

	if ($_REQUEST['act'] == '')
	{
		print_cp_header($vbphrase['vboptimise_testsetup']);

		echo '<script type="text/javascript" src="' . $vbulletin->options['bburl'] . '/vboptimise/clientscript/vboptimise.js"></script>';
		print_table_start();
		print_table_header($vbphrase['vboptimise_testsetup']);
	
		print_description_row('<span class="smallfont"><strong>' . $vbphrase['vboptimise_runtest'] . ':</strong> ' . $vbphrase['vboptimise_connectionto'] . ' ' . $vbulletin->options['vbo_operator'] . '</span>', 0, 2, 'optiontitle');
		print_description_row('<div id="vbo_connection" style="padding: 8px;"><img src="' . $vbulletin->options['bburl'] . '/vboptimise/images/progress.gif" alt="" /></div>');
	
		print_description_row('<span class="smallfont"><strong>' . $vbphrase['vboptimise_runtest'] . ':</strong> ' . $vbphrase['vboptimise_storecache'] . '</span>', 0, 2, 'optiontitle');
		print_description_row('<div id="vbo_store" style="padding: 8px;"><img src="' . $vbulletin->options['bburl'] . '/vboptimise/images/progress.gif" alt="" /></div>');
	
		print_description_row('<span class="smallfont"><strong>' . $vbphrase['vboptimise_runtest'] . ':</strong> ' . $vbphrase['vboptimise_fetchcache'] . '</span>', 0, 2, 'optiontitle');
		print_description_row('<div id="vbo_fetch" style="padding: 8px;"><img src="' . $vbulletin->options['bburl'] . '/vboptimise/images/progress.gif" alt="" /></div>');
	
		print_description_row('<span class="smallfont"><strong>' . $vbphrase['vboptimise_runtest'] . ':</strong> ' . $vbphrase['vboptimise_flushcache'] . '</span>', 0, 2, 'optiontitle');
		print_description_row('<div id="vbo_flush" style="padding: 8px;"><img src="' . $vbulletin->options['bburl'] . '/vboptimise/images/progress.gif" alt="" /></div>');

		echo '<script type="text/javascript">
<!--
vBOptimise.tests.push("connection");
vBOptimise.tests.push("store");
vBOptimise.tests.push("fetch");
vBOptimise.tests.push("flush");
setTimeout("vBOptimise.run_test();", 1500);
-->
</script>';
	
		print_table_footer();
		print_cp_footer();
	}
	else
	{
		require_once(DIR . '/includes/class_xml.php');

		switch ($_REQUEST['act'])
		{
			case 'connection':
			{
				$result = vb_optimise::$cache->connect();
			}
			break;

			case 'store':
			{
				vb_optimise::$cache->set('vbo_systest_temp', 'vB Optimise System Test');

				if (vb_optimise::$cache->get('vbo_systest_temp') != 'vB Optimise System Test')
				{
					$result = false;
					$message = $vbphrase['vboptimise_cachefail'];
				}
				else
				{
					$result = true;
				}
			}
			break;

			case 'fetch':
			{
				// A repeat of the above, but without being set prior. This tests the opcachers ability to maintain cache between sessions. This is a common issue on fastcgi setups

				if (vb_optimise::$cache->get('vbo_systest_temp') != 'vB Optimise System Test')
				{
					$result = false;
					$message = $vbphrase['vboptimise_cachefail'];
				}
				else
				{
					$result = true;
				}
			}
			break;

			case 'flush':
			{
				vb_optimise::$cache->flush();

				if (vb_optimise::$cache->get('vbo_systest_temp') == 'vB Optimise System Test')
				{
					$result = false;
					$message = $vbphrase['vboptimise_flushfail'];
				}
				else
				{
					$result = true;
				}
			}
			break;
		}

		$response = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
		$response->add_group('test');
		$response->add_tag('result', $result ? 'OK' : 'bad');

		if (trim($message))
		{
			$response->add_tag('message', $message);
		}

		$response->close_group();
		$response->print_xml();
	}
}

// ###################### vB Optimise: Optimal Settings Check #######################

if ($_REQUEST['do'] == 'optimal')
{
	print_cp_header($vbphrase['vboptimise_settingscheck']);

	$check_settings = array(
		'storecssasfile'	=> array(
			'good'	=> array(1),
			'edit'	=> 'options.php?' . $vbulletin->session->vars['sessionurl'] . 'do=options&amp;dogroup=stylelang',
		),
		'attachfile'		=> array(
			'good'	=> array(1, 2),
			'edit'	=> 'attachment.php?' . $vbulletin->session->vars['sessionurl'] . 'do=storage',
		),
		'usefileavatar'		=> array(
			'good'	=> array(1),
			'edit'	=> 'avatar.php?' . $vbulletin->session->vars['sessionurl'] . 'do=storage',
		),
		'nocacheheaders'	=> array(
			'good'	=> array(0),
			'edit'	=> 'options.php?' . $vbulletin->session->vars['sessionurl'] . 'do=options&amp;dogroup=http',
		),
		'threadviewslive'	=> array(
			'good'	=> array(0),
			'edit'	=> 'options.php?' . $vbulletin->session->vars['sessionurl'] . 'do=options&amp;dogroup=server',
		),
		'attachmentviewslive'	=> array(
			'good'	=> array(0),
			'edit'	=> 'options.php?' . $vbulletin->session->vars['sessionurl'] . 'do=options&amp;dogroup=server',
		),
	);

	print_table_start();

	print_column_style_code(array('width:55%', 'width:45%'));

	print_table_header($vbphrase['vboptimise_settingscheck']);

	foreach ($check_settings as $setting => $optimal)
	{
		if (!isset($vbulletin->options[$setting]))
		{
			continue;
		}

		print_description_row('<span style="float: right;" class="smallfont"><a href="' . $optimal['edit'] . '">[' . $vbphrase['vboptimise_edit_setting'] . ']</a></span>' . $vbphrase['vboptimise_' . $setting], 0, 2, 'optiontitle');

		$result = 'good';

		if (!in_array($vbulletin->options[$setting], $optimal['good']))
		{
			$result = 'bad';
		}

		$result = '<img src="' . $vbulletin->options['bburl'] . '/vboptimise/images/vboptimise_' . $result . '.png" style="float: ' . $stylevar['right'] . '; padding-right: 10px; vertical-align: middle;" alt="" />' . (
		$result == 'good' ? $vbphrase['vboptimise_setting_good'] : $vbphrase['vboptimise_setting_bad']);

		print_label_row('<div class="smallfont">' . $vbphrase['vboptimise_' . $setting . '_desc'] . '</div>', $result, '', 'top');
	}

	print_table_footer();
	print_cp_footer();
}
?>